
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:10:59 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version PLAT_SystemDep.c#1:csrc:2
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/ 

#include "PLAT_SystemDep.h"
#include "CRYS.h"
#include "DX_VOS_Mem.h"
#include "dx_hw_defs.h"
#include "crys_host_op_code.h"



/* canceling the lint warning:
   Unusual pointer cast (incompatible indirect types) */
/*lint --e{785} */
/*lint --e{740} */

/************************ Defines ******************************/

/************************ Enums ******************************/

/************************ Typedefs ******************************/
 
/************************ Global Data ******************************/

/************************ Private Functions ******************************/
/**
 * @brief This function executes the CRYS self test.
 *
 * 
 *
 * @param[in] EnginesSelect - selecting the engines to activate according to the following values:
 *
 *                            CRYS_SELF_TEST_AES_BIT     
 *                            CRYS_SELF_TEST_DES_BIT     
 *                            CRYS_SELF_TEST_HASH_BIT
 *                            CRYS_SELF_TEST_HMAC_BIT
 *                            CRYS_SELF_TEST_RSA_ENCDEC_BIT     
 *                            CRYS_SELF_TEST_RND_BIT     
 *                            CRYS_SELF_TEST_ALL_BIT     
 *
 * @param[in] EnginesTestResult_ptr - a bit field describing the test results of the engines.
 *                                    the bit field is the same as described above.
 *                                    on each bit : 0 - test passes , 1 - test failure. 
 *
 * @param[in] TempData_ptr - a temp pointer of a temp buffer required for the self test. 
 *                            
 * @return CRYSError_t - On success the function returns the value CRYS_OK, 
 *			                 and on failure a non-ZERO error.

 */

 CRYSError_t  CRYS_SelfTest(DxUint16_t EnginesSelect,
                            DxUint16_t *EnginesTestResult_ptr,
                            CRYS_SelfTestData_t *TempData_ptr )
{
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_SELF_TEST_OP_CODE, 3,
	   							 /* PARAMETERS: */
								 EnginesSelect,
								 EnginesTestResult_ptr,
								 TempData_ptr );

}/* END OF CRYS_SelfTest function */                               
 



